/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.soap.server;

import filenet.vw.base.logging.Logger;
import filenet.vw.server.IPECommands;
import filenet.vw.server.PECommandsFactory;
import filenet.vw.server.VWBootstrapURL;
import filenet.vw.soap.server.IVWCommandManager;
import filenet.vw.soap.server.IVWSOAPContext;
import filenet.vw.soap.server.VWRouterInfo;
import filenet.vw.soap.server.VWSOAPCommandHandler;
import filenet.vw.soap.server.VWSOAPSessionInfo;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.soap.Constants;
import org.apache.soap.SOAPException;

class VWSOAPService
implements IVWCommandManager,
IVWSOAPContext {
    private Hashtable m_cpServiceTable = new Hashtable(3);
    private Hashtable m_commandTable = new Hashtable(3);
    private static final Logger logger = Logger.getLogger("filenet.vw.soap.server");
    private static final String m_className = "VWSOAPService";
    private Hashtable m_context = new Hashtable(3);

    public static String _get_FILE_DATE() {
        return "$Date:   12 Oct 2006 01:09:42  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.21  $";
    }

    private synchronized VWSOAPCommandHandler getCommandHandler(String fullCP) throws SOAPException {
        String m_method = "getCommandHandler:" + fullCP;
        String ceURI = this.getPeregrineSession().getCEURI();
        try {
            new VWBootstrapURL(fullCP);
        }
        catch (Exception e) {
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "Need to add cEURI..");
            }
            try {
                fullCP = VWBootstrapURL.GetBootstrapURI(ceURI, fullCP);
            }
            catch (Exception ee) {
                logger.throwing(m_className, m_method, ee);
                throw new SOAPException(Constants.FAULT_CODE_SERVER, "Connection Point : " + fullCP + " is invalid. Ex=" + ee.getMessage());
            }
        }
        VWSOAPCommandHandler res = (VWSOAPCommandHandler)this.m_cpServiceTable.get(fullCP);
        if (res == null) {
            VWRouterInfo routerInfo = this.getVWRouterInfo(fullCP);
            if (routerInfo.getBootstrapCEURI() == null) {
                try {
                    routerInfo.setBootstrapCEURI(this.getPeregrineSession().getCEURI());
                }
                catch (Exception e) {
                    logger.throwing(m_className, m_method, e);
                }
            }
            res = new VWSOAPCommandHandler(routerInfo, this.getCommand(routerInfo.getFullURL(), true), this.getPeregrineSession(), this);
            this.m_cpServiceTable.put(fullCP, res);
        }
        return res;
    }

    private VWRouterInfo getVWRouterInfo(String fullCP) throws SOAPException {
        VWRouterInfo routerInfo = null;
        routerInfo = (VWRouterInfo)this.getCPsInfo().get(fullCP);
        if (routerInfo == null) {
            try {
                routerInfo = new VWRouterInfo(fullCP);
            }
            catch (Exception e) {
                throw new SOAPException(Constants.FAULT_CODE_SERVER, "Connection Point : " + fullCP + " is invalid. Ex=" + e.getMessage());
            }
            this.getCPsInfo().put(fullCP, routerInfo);
        }
        return routerInfo;
    }

    protected Hashtable getCPsInfo() throws SOAPException {
        Hashtable CPsInfo = (Hashtable)this.m_context.get("ConnecionPointsInfo");
        if (CPsInfo == null) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "No connection points are available");
        }
        return CPsInfo;
    }

    protected VWSOAPSessionInfo getPeregrineSession() throws SOAPException {
        VWSOAPSessionInfo ses = (VWSOAPSessionInfo)this.m_context.get("PeregrineSession");
        if (ses == null) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "No session info available");
        }
        return ses;
    }

    public IPECommands getCommand(String fullCP, boolean reconnect) throws SOAPException {
        String m_method = "getCommand:fullCP=" + fullCP + ", reconnect=" + new Boolean(reconnect).toString();
        logger.entering(m_className, m_method);
        IPECommands cmd = (IPECommands)this.m_commandTable.get(fullCP);
        if (cmd == null || reconnect) {
            try {
                VWSOAPSessionInfo ses = this.getPeregrineSession();
                String user = ses.getUser();
                String pw = ses.getPassword();
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "LOOK:" + user + "," + pw);
                }
                cmd = PECommandsFactory.getPECommands(null, user, pw, fullCP);
            }
            catch (Exception e) {
                logger.throwing(m_className, m_method, e);
                throw new SOAPException(Constants.FAULT_CODE_SERVER, "Failed to connect to " + fullCP, (Throwable)e);
            }
            finally {
                logger.exiting(m_className, m_method);
            }
            this.setCommand(fullCP, cmd);
        }
        return cmd;
    }

    public void setCommand(String fullCP, IPECommands cmd) {
        String m_method = "setCommand:" + fullCP;
        if (cmd != null) {
            this.m_commandTable.put(fullCP, cmd);
        } else {
            this.m_commandTable.remove(fullCP);
        }
    }

    public void setContext(String key, Object value) {
        this.m_context.put(key, value);
    }

    public Object getContext(String key) {
        return this.m_context.get(key);
    }

    public byte[] sendCommand(String cpName, String rpc, byte[] cmd) throws SOAPException {
        VWSOAPCommandHandler handler = this.getCommandHandler(cpName);
        return handler.sendCommand(rpc, cmd);
    }

    public String getServiceURL(String cpName) throws SOAPException {
        throw new SOAPException(Constants.FAULT_CODE_SERVER, "Not implemented");
    }

    public int getIsolatedRegion(String cpName) throws SOAPException {
        throw new SOAPException(Constants.FAULT_CODE_SERVER, "Not Implemented");
    }

    protected void finalize() {
        this.cleanupEx();
    }

    public void cleanup() {
    }

    public void cleanupEx() {
        logger.entering(m_className, "CleanupEx");
        this.m_commandTable.clear();
        if (!this.m_cpServiceTable.isEmpty()) {
            Enumeration e = this.m_cpServiceTable.elements();
            while (e.hasMoreElements()) {
                ((VWSOAPCommandHandler)e.nextElement()).cleanup();
            }
        }
        this.m_cpServiceTable.clear();
        logger.exiting(m_className, "CleanupEx");
    }
}

